% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mortality}
\alias{mortality}
\title{Mortality Dataset}
\format{
A data frame with 123 rows and 25 variables:
\describe{
\item{V1}{Patient ID.}
\item{V2}{Age of the patient.}
\item{V3}{Gender of the patient.}
\item{V4}{Wheter the patient has sepsis.}
\item{COMORBILIDAD}{Wheter the patient has diabetes mellitus.}
\item{V6}{Wheter the patient has arterial hypertehsion.}
\item{V7}{Wheter the patient is obese.}
\item{V8}{Whether the patient has Chronic Obstructive Pulmonary Disease.}
\item{V9}{Whether the patient has Chronic Kidney Disease.}
\item{V10}{Whether the patient has other comorbidities.}
\item{SITIOSDEINFECCIÓN}{Site of pulmonary infection.}
\item{V12}{Site of urinary infection.}
\item{V13}{Site of abdominal infection.}
\item{V14}{Site of soft tissue infection.}
\item{V15}{Site of urinary infection.}
\item{V16}{Site of other infection.}
\item{V17}{Q SOFA score}
\item{V18}{NEWS 2 score}
\item{V19}{Total NEWS 2 score}
\item{V20}{SOFA score}
\item{V21}{Total SOFA score}
\item{V22}{Severity of the patient's conditions }
\item{V23}{Whether the patient survived or died}
\item{V24}{Length of stay in hours}
\item{Agrupada}{Age group}
}
}
\usage{
mortality
}
\description{
contains information about patients with various medical
conditions. It includes patient demographics, comorbidities, infection sites,
severity scores, mortality status, length of stay and age group.
}
\examples{
\donttest{
  # Load the dataset
  data("mortality", package = "viruslearner")
  # Explore the dataset
  library(dplyr)
  dplyr::glimpse(mortality)
}
}
\keyword{datasets}
