% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateDriver.R
\name{simulateDriver}
\alias{simulateDriver}
\title{Generates a random time series with temporal autocorrelation.}
\usage{
simulateDriver(
  random.seed = 30,
  time = 1:10000,
  autocorrelation.length = 100,
  output.min = 0,
  output.max = 100,
  rescale = TRUE
  )
}
\arguments{
\item{random.seed}{integer, seed to be used by \code{set.seed()}. Default is 50.}

\item{time}{integer, or numeric vector of integers with constant intervals. If a single integer is provided, a time sequence is generated from 1 to the given integer as \emph{seq(1, time, by = 1)}. Default is 1:10000.}

\item{autocorrelation.length}{integer, represents the length of the convolution filter to be used to impose a particular temporal structure on the time series. Default is 100, equivalent to a filter composed by a hundred of ones.}

\item{output.min}{numeric, minimum value of the output time series. Used as input for\code{\link{rescaleVector}}. Default is 0.}

\item{output.max}{numeric, maximum value of the output time series. Used as input for \code{\link{rescaleVector}}. Default is 100.}

\item{rescale}{boolean. If FALSE, \code{output.min} and \code{output.max} are ignored, and the original data range provided by \code{rnorm} is preserved. Default is TRUE.}
}
\value{
A vector of the same length as \code{time}. Datasets \code{\link{driverA}} and \code{\link{driverB}} are outputs of this function.
}
\description{
Generates a vector of the same legnth as the \code{time} argument, with a temporal autocorrelation length close to the defined by \code{autocorrelation.length}, and a range within \code{output.min} and \code{output.max}. The output of this function is intended to be used as an input to the function \code{\link{simulatePopulation}}. \strong{Important}: note that the variable \code{time} runs from left to right in \code{\link{simulatePopulation}}, with lower values representing older samples.
}
\details{
It is recommended to use \code{time} vectors with a time step of 1 between consecutive values when the output is to be used as input for \code{\link{simulatePopulation}}, which considers annual time-steps while simulating virtual pollen curves. The initial random sequence of numers is generated by \code{rnorm}. Desired temporal autocorrelation are approximate, but deviation becomes higher if \code{autocorrelation.length} is larger than half the length of \code{time}. Consequently, the function limits \code{autocorrelation.length} to \code{length(time)/2}.
}
\examples{

x <- simulateDriver(
  random.seed = 30,
  time = 1:10000,
  autocorrelation.length = 100,
  output.min = -10,
  output.max = 20,
  rescale = TRUE
  )

#plots output
plot(x, type = "l")

#checks temporal autocorrelation
acf(x, lag.max = 300)

}
\seealso{
\code{\link{rescaleVector}}, \code{\link{driverA}}, \code{\link{driverB}}, \code{\link{set.seed}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
