% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_color_viridis}
\alias{scale_color_viridis}
\alias{scale_colour_viridis}
\alias{scale_fill_viridis}
\title{Viridis color scales}
\usage{
scale_color_viridis(..., alpha = 1, begin = 0, end = 1,
  discrete = FALSE, option = "D")

scale_fill_viridis(..., alpha = 1, begin = 0, end = 1, discrete = FALSE,
  option = "D")
}
\arguments{
\item{...}{parameters to \code{discrete_scale} or \code{scale_fill_gradientn}}

\item{alpha}{pass through parameter to \code{viridis}}

\item{begin}{The (corrected) hue in [0,1] at which the viridis colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the viridis colormap ends.}

\item{discrete}{generate a discrete palette? (default: \code{FALSE} - generate continuous palette)}

\item{option}{A character string indicating the colormap option to use. Four
options are available: "magma" (or "A"), "inferno" (or "B"), "plasma" (or "C"),
and "viridis" (or "D", the default option).}
}
\description{
Uses the viridis color scale.
}
\details{
For \code{discrete == FALSE} (the default) all other arguments are as to
\link[ggplot2]{scale_fill_gradientn} or \link[ggplot2]{scale_color_gradientn}.
Otherwise the function will return a \code{discrete_scale} with the plot-computed
number of colors.

See \link[viridis]{viridis} for more information on the color scale.
}
\examples{
library(ggplot2)

# ripped from the pages of ggplot2
p <- ggplot(mtcars, aes(wt, mpg))
p + geom_point(size=4, aes(colour = factor(cyl))) +
    scale_color_viridis(discrete=TRUE) +
    theme_bw()

# ripped from the pages of ggplot2
dsub <- subset(diamonds, x > 5 & x < 6 & y > 5 & y < 6)
dsub$diff <- with(dsub, sqrt(abs(x-y))* sign(x-y))
d <- ggplot(dsub, aes(x, y, colour=diff)) + geom_point()
d + scale_color_viridis() + theme_bw()


# from the main viridis example
dat <- data.frame(x = rnorm(10000), y = rnorm(10000))

ggplot(dat, aes(x = x, y = y)) +
  geom_hex() + coord_fixed() +
  scale_fill_viridis() + theme_bw()

library(ggplot2)
library(MASS)
library(gridExtra)

data("geyser", package="MASS")

ggplot(geyser, aes(x = duration, y = waiting)) +
  xlim(0.5, 6) + ylim(40, 110) +
  stat_density2d(aes(fill = ..level..), geom="polygon") +
  theme_bw() +
  theme(panel.grid=element_blank()) -> gg

grid.arrange(
  gg + scale_fill_viridis(option="A") + labs(x="Virdis A", y=NULL),
  gg + scale_fill_viridis(option="B") + labs(x="Virdis B", y=NULL),
  gg + scale_fill_viridis(option="C") + labs(x="Virdis C", y=NULL),
  gg + scale_fill_viridis(option="D") + labs(x="Virdis D", y=NULL),
  ncol=2, nrow=2
)

}
\author{
Noam Ross \email{noam.ross@gmail.com} / \href{https://twitter.com/noamross}{@noamross} (continuous version),
        Bob Rudis \email{bob@rudis.net} / \href{https://twitter.com/hrbrmstr}{@hrbrmstr} (combined version)
}

