% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi_model.R
\name{vi_model}
\alias{vi_model}
\alias{vi_model.default}
\alias{vi_model.C5.0}
\alias{vi_model.constparty}
\alias{vi_model.earth}
\alias{vi_model.gbm}
\alias{vi_model.H2OBinomialModel}
\alias{vi_model.H2OMultinomialModel}
\alias{vi_model.H2ORegressionModel}
\alias{vi_model.lm}
\alias{vi_model.ml_model_decision_tree_regression}
\alias{vi_model.ml_model_decision_tree_classification}
\alias{vi_model.ml_model_gbt_regression}
\alias{vi_model.ml_model_gbt_classification}
\alias{vi_model.ml_model_random_forest_regression}
\alias{vi_model.ml_model_random_forest_classification}
\alias{vi_model.randomForest}
\alias{vi_model.RandomForest}
\alias{vi_model.ranger}
\alias{vi_model.rpart}
\alias{vi_model.train}
\alias{vi_model.xgb.Booster}
\title{Model-Based Variable Importance}
\usage{
vi_model(object, ...)

\method{vi_model}{default}(object, ...)

\method{vi_model}{C5.0}(object, ...)

\method{vi_model}{constparty}(object, ...)

\method{vi_model}{earth}(object, ...)

\method{vi_model}{gbm}(object, ...)

\method{vi_model}{H2OBinomialModel}(object, ...)

\method{vi_model}{H2OMultinomialModel}(object, ...)

\method{vi_model}{H2ORegressionModel}(object, ...)

\method{vi_model}{lm}(object, ...)

\method{vi_model}{ml_model_decision_tree_regression}(object, ...)

\method{vi_model}{ml_model_decision_tree_classification}(object, ...)

\method{vi_model}{ml_model_gbt_regression}(object, ...)

\method{vi_model}{ml_model_gbt_classification}(object, ...)

\method{vi_model}{ml_model_random_forest_regression}(object, ...)

\method{vi_model}{ml_model_random_forest_classification}(object, ...)

\method{vi_model}{randomForest}(object, ...)

\method{vi_model}{RandomForest}(object, auc = FALSE, ...)

\method{vi_model}{ranger}(object, ...)

\method{vi_model}{rpart}(object, ...)

\method{vi_model}{train}(object, ...)

\method{vi_model}{xgb.Booster}(object, ...)
}
\arguments{
\item{object}{A fitted model object (e.g., a \code{"randomForest"} object).}

\item{...}{Additional optional arguments.}

\item{auc}{Logical indicating whether or not to compute the AUC-based
variable scores described in Janitza et al. (2012). Only available for
\code{\link[party]{cforest}} objects. See
\code{\link[party]{varimpAUC}} for details. Default is \code{FALSE}.}
}
\value{
A tidy data frame (i.e., a \code{"tibble"} object) with two columns:
\code{Variable} and \code{Importance}. For \code{"glm"}-like object, an
additional column, called \code{Sign}, is also included which includes the
sign (i.e., POS/NEG) of the original coefficient.
}
\description{
Compute model-based variable importance scores for the predictors in a model.
(This function is meant for internal use only.)
}
\details{
Coming soon!
}
