% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statespace.R
\name{statespace}
\alias{statespace}
\title{Design a State-Space Model}
\usage{
statespace(X, y, kalman_params = NULL, viking_params = NULL, ...)
}
\arguments{
\item{X}{design matrix.}

\item{y}{variable of interest.}

\item{kalman_params}{(default \code{NULL}) list containing initial values for \code{theta,P}
as well as the variances (\code{Q,sig}). If it is not specified, the state-space model is
constructed in the static setting (\code{theta=0, P=I, Q=0, sig=1}).}

\item{viking_params}{(default \code{NULL}) list of parameters for the Viking algorithm.}

\item{...}{additional parameters}
}
\value{
a statespace object.
}
\description{
The function \code{statespace} builds a state-space model, with known or unknown variances.
By default, this function builds a state-space model in the static setting, with a constant
state (zero state noise covariance matrix) and constant observation noise variance.
}
\examples{
set.seed(1)
### Simulate data
n <- 1000
d <- 5
Q <- diag(c(0,0,0.25,0.25,0.25))
sig <- 1

X <- cbind(matrix(rnorm((d-1)*n,sd=1),n,d-1),1)
theta <- matrix(rnorm(d), d, 1)
theta_arr <- matrix(0, n, d)
for (t in 1:n) {
  theta_arr[t,] <- theta
  theta <- theta + matrix(mvtnorm::rmvnorm(1,matrix(0,d,1),Q),d,1)
}
y <- rowSums(X * theta_arr) + rnorm(n, sd=sig)

####################
### Kalman Filter
# Default Static Setting
ssm <- viking::statespace(X, y)
plot(ssm)

# Known variances
ssm <- viking::statespace(X, y, kalman_params = list(Q=Q, sig=sig))
plot(ssm)

}
