% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb_who.R
\name{tb_who}
\alias{tb_who}
\title{Create main WHO tables}
\usage{
tb_who(path_who, force = FALSE)
}
\arguments{
\item{path_who}{Character string, a directory containing whodrug txt tables. It is also the
output directory.}

\item{force}{Logical, to be passed to \code{cli::cli_progress_update()}. Used for internal
purposes.}
}
\value{
.parquet files into the \code{path_who} directory.
Some columns are returned as \code{integer} (all Id columns, including MedicinalProd_Id,
with notable exception of DrecNo),
and some columns as \code{numeric} (Quantity from ingredient table)
All other columns are \code{character}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Transform Vigibase WHO .txt files
to .parquet files

WHODrug is delivered as zipped text files folder, that you should
transform to a more efficient format. Parquet format from arrow has many advantages:
It can work with out-of-memory data, which makes it possible to process tables on
a computer with not-so-much RAM. It is also lightweighted and standard across different
languages.
The function also creates variables in each table. See \code{\link[=tb_vigibase]{tb_vigibase()}} for some running examples, and try \code{?mp_} or \code{?thg_} for more details.
Use \code{\link[=dt_parquet]{dt_parquet()}} to load the tables afterward.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Use the examples from tb_main if you want to see these functions in action.

path_who <- paste0(tempdir(), "/whodrug_directory/")
dir.create(path_who)
create_ex_who_txt(path_who)

tb_who(path_who = path_who)

# Clear temporary files when you're done
unlink(path_who, recursive = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tb_vigibase]{tb_vigibase()}}, \code{\link[=tb_meddra]{tb_meddra()}}, \code{\link[=tb_subset]{tb_subset()}}, \code{\link[=dt_parquet]{dt_parquet()}}
}
