% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directional_visibility.R
\name{d_visibility}
\alias{d_visibility}
\title{Computes the directional visibility from a single location in a 3D point cloud}
\usage{
d_visibility(
  data,
  position,
  angular_res,
  elevation_range,
  azimuth_range,
  scene_radius,
  store_points
)
}
\arguments{
\item{data}{LAS class object containing the xyz coordinates of a 3D point
cloud.}

\item{position}{vector of length 3 containing the xyz coordinates of the
animal location. Default = c(0,0,0).}

\item{angular_res}{numeric. The angular resolution of a single sightline.
Default = 1.}

\item{elevation_range}{(optional) numeric vector. The elevation range used to
segment the viewshed. Range between 0 and 180.}

\item{azimuth_range}{(optional) numeric vector. The azimuth range used to
segment the viewshed. Range between 0 and 360.}

\item{scene_radius}{(optional) numeric. Defines the radius of the scene
relative to the animal position. Can be used to apply a cut-off distance to
visibility analyses.}

\item{store_points}{logical. If \code{TRUE}, the 3D point cloud is returned
with visible and not visible points classified (see details in \code{\link{visibility}}).}
}
\value{
Similar to those of Similar of the \code{\link{visibility}} function.
}
\description{
Similar to the \code{\link{visibility}} function but allow to
segment the viewshed by azimuth and elevation to analyze visibility in a
given direction.
}
\note{
If \code{elevation_range} and \code{azimuth_range} are not defined, the
outputs are similar to those obtained with the \code{\link{visibility}} function
but the computation is less efficient.
}
\examples{
\donttest{
# produce a spherical point cloud
sph <- lidR::LAS(generate_sphere(angular_res = 0.1,r = 1.5))


# compute visibility without segmentation
view.data <- d_visibility(data = sph,
                         position = c(0,0,0),
                         angular_res = 1,
                         store_points = TRUE,
                         scene_radius = 2)

# plot the viewshed
lidR::plot(view.data$points,colorPalette = "darkgreen")

# compute visibility segmented by elevation
view.data <- d_visibility(data = sph,
                         position = c(0,0,0),
                         angular_res = 1,
                         store_points = TRUE,
                         scene_radius = 2,
                         elevation_range = c(80,100))

# plot the viewshed
lidR::plot(view.data$points,colorPalette = "darkgreen")

# compute visibility segmented by azimuth
view.data <- d_visibility(data = sph,
                         position = c(0,0,0),
                         angular_res = 1,
                         store_points = TRUE,
                         scene_radius = 2,
                         azimuth_range = c(85,105))

# plot the viewshed
lidR::plot(view.data$points,colorPalette = "darkgreen")

# compute visibility segmented by azimuth and elevation
view.data <- d_visibility(data = sph,
                          position = c(0,0,0),
                          angular_res = 1,
                          store_points = TRUE,
                          scene_radius = 2,
                          azimuth_range = c(350,10),
                          elevation_range = c(80,100))

# plot the viewshed
lidR::plot(view.data$points,colorPalette = "darkgreen")
}
}
