% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_viewshed.R
\name{compute_viewshed}
\alias{compute_viewshed}
\title{compute_viewshed}
\usage{
compute_viewshed(
  dsm,
  viewpoints,
  offset_viewpoint = 1.7,
  offset_height = 0,
  r = NULL,
  parallel = FALSE,
  workers = 0,
  raster = FALSE,
  plot = FALSE
)
}
\arguments{
\item{dsm}{Raster, the digital surface model/digital elevation model}

\item{viewpoints}{sf point(s) or vector including x,y coordinates of a viewpoint
or a matrix including several viewpoints with x,y coordinates}

\item{offset_viewpoint}{numeric, setting the height of the viewpoint.
(default is 1.7 meters).}

\item{offset_height}{numeric, setting the height of positions that a given
viewpoint will look at. (defaut is 0)}

\item{r}{Numeric (optional), setting the radius for viewshed analysis.
(it is defaulted as NULL)}

\item{parallel}{Logical, (default is FALSE) indicating if parallel computing
should be used to compute viewsheds of multiview points. When it is TRUE,
arguements 'raster' and 'plot' are ignored}

\item{workers}{Numeric, indicating the number of CPU cores that will be used
for parallel computing. It is required if 'parallel' is 'TRUE'.}

\item{raster}{Logical, (default is FALSE) if it is TRUE, the raster of
viewshed will be returned.
The default is FALSE}

\item{plot}{Logical, (default is FALSE) if it is TRUE, the raster of
viewshed will be displayed}
}
\value{
Raster or list. For single-viewpoint analysis, the function returns
either a raster (raster is TRUE) or a viewshed object. Value 1 means visible while
value 0 means invisible. For multi-viewpoint analysis, a list of viewsheds
is returned.
}
\description{
The compute_viewshed function is designed for computing viewsheds,
which are areas visible from specific viewpoints, based on a Digital Surface
Model (DSM). It provides flexibility for single or multi-viewpoint analyses
and allows options for parallel processing, raster output, and plotting.
}
\examples{
# Load a viewpoint
test_viewpoint <- sf::read_sf(system.file("test_viewpoint.shp", package = "viewscape"))
# load dsm raster
dsm <- terra::rast(system.file("test_dsm.tif", package ="viewscape"))
#Compute viewshed
output <- compute_viewshed(dsm = dsm,
                           viewpoints = test_viewpoint,
                           offset_viewpoint = 6)
}
