% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{bench_mark}
\alias{bench_mark}
\title{Lightweight Benchmarking Function}
\usage{
bench_mark(..., times = 1000L)
}
\arguments{
\item{...}{expressions to benchmark, are captured unevaluated}

\item{times}{how many times to loop, defaults to 1000}
}
\value{
NULL, invisibly, reports timings as a side effect as screen output
bench_mark(runif(1000), Sys.sleep(0.1))
}
\description{
Evaluates provided expression in a loop and reports mean evaluation time.
This is inferior to \code{microbenchmark} and other benchmarking tools in many
ways except that it has zero dependencies or suggests which helps with
package build and test times.  Used in vignettes.
}
\details{
Runs \code{\link[=gc]{gc()}} before each expression is evaluated.  Expressions are evaluated
in the order provided.  Attempts to estimate the overhead of the loop by
running a loop that evaluates \code{NULL} the \code{times} times.

Unfortunately because this computes the average of all iterations it is very
susceptible to outliers in small sample runs, particularly with fast running
code.  For that reason the default number of iterations is one thousand.
}
