% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice-unmatched.R
\name{slice_unmatched}
\alias{slice_unmatched}
\alias{slice_unmatched_both}
\title{Get rows in only one table}
\usage{
slice_unmatched(comparison, table)

slice_unmatched_both(comparison)
}
\arguments{
\item{comparison}{The output of \code{compare()}}

\item{table}{One of \code{"a"} or \code{"b"} indicating which of the tables used to
create \code{comparison} should be sliced}
}
\value{
\item{\code{slice_unmatched()}}{The table identified by \code{table} is filtered
to the rows \code{comparison} shows as not appearing in the other table}
\item{\code{slice_unmatched_both()}}{The output of \code{slice_unmatched()} for both input
tables row-stacked with a column \code{table} indicating which table the row
is from. The output contains only columns present in both tables.}
}
\description{
Get rows in only one table
}
\examples{
comp <- compare(example_df_a, example_df_b, by = car)
comp |> slice_unmatched("a")
comp |> slice_unmatched("b")

# slice_unmatched(comp, "a") output is the same as
example_df_a |> dplyr::anti_join(example_df_b, by = comp$by$column)

comp |> slice_unmatched_both()
}
