% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_vennLasso.R
\name{predict.vennLasso}
\alias{predict.vennLasso}
\title{Prediction for Hierarchical Shared Lasso}
\usage{
\method{predict}{vennLasso}(object, newx, group.mat, s = NULL,
  use.refit = FALSE, type = c("link", "response", "coefficients",
  "nonzero", "class", "nvars", "median", "survival"), ...)
}
\arguments{
\item{object}{fitted vennLasso object}

\item{newx}{new matrix for predictions}

\item{group.mat}{A matrix of the group memberships for now. Ignore the rest:
A list of length equal to the number of groups containing vectors of integers
indicating the variable IDs for each group. For example, groups=list(c(1,2), c(2,3), c(3,4,5)) specifies
that Group 1 contains variables 1 and 2, Group 2 contains variables 2 and 3, and Group 3 contains
variables 3, 4, and 5. Can also be a matrix of 0s and 1s with the number of columns equal to the
number of groups and the number of rows equal to the number of variables. A value of 1 in row i and
column j indicates that variable i is in group j and 0 indicates that variable i is not in group j.}

\item{s}{lambda value for the predictions. defaults to all values computed in the vennLasso object}

\item{use.refit}{Should the refitted beta estimates be used for prediction? Defaults to FALSE. If TRUE
then the beta estimates from the model refit on just the selected covariates are used}

\item{type}{type of predictions to be made. \code{type = "median"} is for the median survival time and 
\code{type = "survival"} is for the predicted hazard function}

\item{...}{parameters to be passed to vennLasso}
}
\value{
predictions or coefficients
}
\description{
Prediction for Hierarchical Shared Lasso
}
