% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_to_wide.R
\name{long_to_wide}
\alias{long_to_wide}
\title{Transform data.frame from long to wide format}
\usage{
long_to_wide(
  df,
  column_with_new_names = names(df)[1],
  column_with_data = "emission",
  column_fixed,
  net
)
}
\arguments{
\item{df}{data.frame with three column.}

\item{column_with_new_names}{Character, column that has new column names}

\item{column_with_data}{Character column with data}

\item{column_fixed}{Character,  column that will remain fixed}

\item{net}{To return a sf}
}
\value{
wide data.frame.
}
\description{
\code{\link{long_to_wide}} transform data.frame from long to
wide format
}
\examples{
\dontrun{
df <- data.frame(pollutant = rep(c("CO", "propadiene", "NO2"), 10),
emission = vein::Emissions(1:30),
region = rep(letters[1:2], 15))
df
long_to_wide(df)
long_to_wide(df, column_fixed = "region")
}
}
\seealso{
\code{\link{emis_hot_td}} \code{\link{emis_cold_td}} \code{\link{wide_to_long}}
}
