% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_ldv.R
\name{age_ldv}
\alias{age_ldv}
\title{Returns amount of vehicles at each age}
\usage{
age_ldv(x, name, a = 1.698, b = -0.2, agemin = 1, agemax = 50, k = 1,
  bystreet = F)
}
\arguments{
\item{x}{numerical vector of vehicles}

\item{name}{of vehicle assigned to columns of dataframe}

\item{a}{parameter of survival equation}

\item{b}{parameter of survival equation}

\item{agemin}{age of newest vehicles for that category}

\item{agemax}{age of oldest vehicles for that category}

\item{k}{multiplication factor}

\item{bystreet}{when TRUE it is expecting that 'a' and 'b' are numeric vectors with length equal to x}
}
\value{
dataframe of age distrubution of vehicles
}
\description{
Returns amount of vehicles at each age
}
\examples{
\dontrun{
# Do not run
pc <- rnorm(100, 300, 10)
PC_E25_1400 <- age_ldv(x = pc,name = "PC_E25_1400")
plot(PC_E25_1400)
}
}
