% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaporative.R
\name{Evaporative}
\alias{Evaporative}
\alias{print.Evaporative}
\alias{summary.Evaporative}
\alias{plot.Evaporative}
\alias{print.Evaporative}
\alias{summary.Evaporative}
\alias{plot.Evaporative}
\title{Construction function for class "Evaporative"}
\usage{
Evaporative(x, ...)

\method{print}{Evaporative}(x, ...)

\method{summary}{Evaporative}(object, ...)

\method{plot}{Evaporative}(x, ...)
}
\arguments{
\item{x}{Object with class "numeric"}

\item{...}{ignored}

\item{object}{Object with class "Evaporative"}
}
\value{
Objects of class "Evaporative" or "units"
}
\description{
Returns a tranformed object with class "Evaporative" and
units g/day. This class represents the daily emissions presented by
Mellios G and Ntziachristos (2016) Gasoline evaporation, Tier 2. Eventually
it will be incorporated the techniques of Tier 3.
}
\examples{
\dontrun{
ef1 <- ef_evap(ef = "erhotc",v = "PC", cc = "<=1400", dt = "0_15", ca = "no")
class(ef1)
dfe <- emis_evap(rep(50,3),"PC","<=1400","G", 1:3,
                     10,4,2,1,
                     ef1*1:3, ef1*1:3, ef1*1:3, ef1*1:3,
                     ef1*1:3, ef1*1:3, ef1*1:3, ef1*1:3,
                     ef1*1:3, ef1*1:3, ef1*1:3, ef1*1:3)
}
}
