% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectoryDistances.R
\encoding{UTF-8}
\name{trajectories}
\alias{trajectories}
\alias{segmentDistances}
\alias{trajectoryDistances}
\alias{trajectoryLengths}
\alias{trajectoryAngles}
\alias{trajectoryPCoA}
\alias{trajectoryProjection}
\alias{trajectoryConvergence}
\alias{trajectoryDirectionality}
\alias{centerTrajectories}
\alias{trajectoryDistances}
\alias{trajectoryLengths}
\alias{trajectoryAngles}
\alias{trajectoryPCoA}
\alias{trajectoryPlot}
\alias{trajectoryProjection}
\alias{trajectoryConvergence}
\alias{trajectoryDirectionality}
\alias{centerTrajectories}
\title{Community trajectory analysis}
\usage{
segmentDistances(d, sites, surveys = NULL,
  distance.type = "directed-segment", verbose = FALSE)

trajectoryDistances(d, sites, surveys = NULL, distance.type = "DSPD",
  symmetrization = "mean", verbose = FALSE)

trajectoryLengths(d, sites, surveys = NULL, verbose = FALSE)

trajectoryAngles(d, sites, surveys = NULL, all = FALSE, verbose = FALSE)

trajectoryPCoA(d, sites, surveys = NULL, selection = NULL,
  traj.colors = NULL, axes = c(1, 2), ...)

trajectoryPlot(x, sites, surveys = NULL, selection = NULL,
  traj.colors = NULL, axes = c(1, 2), ...)

trajectoryProjection(d, target, trajectory, tol = 1e-06)

trajectoryConvergence(d, sites, surveys = NULL, symmetric = FALSE,
  verbose = FALSE)

trajectoryDirectionality(d, sites, surveys = NULL, verbose = FALSE)

centerTrajectories(d, sites, surveys = NULL, verbose = FALSE)
}
\arguments{
\item{d}{A symmetric \code{\link{matrix}} or an object of class \code{\link{dist}} containing the distance values between pairs of community states.}

\item{sites}{A vector indicating the site corresponding to each community state.}

\item{surveys}{A vector indicating the survey corresponding to each community state (only necessary when surveys are not in order).}

\item{distance.type}{The type of distance index to be calculated (Besse et al. 2016; De Cáceres et al. submitted). For \code{segmentDistances} the available indices are:
  \itemize{
    \item{\code{Hausdorff}: Hausdorff distance between two segments.}
    \item{\code{directed-segment}: Directed segment distance (default).}
    \item{\code{PPA}: Perpendicular-parallel-angle distance.}
  }
whereas for \code{trajectoryDistances} the available indices are:
  \itemize{
    \item{\code{Hausdorff}: Hausdorff distance between two trajectories.}
    \item{\code{SPD}: Segment path distance.}
    \item{\code{DSPD}: Directed segment path distance (default).}
  }}

\item{verbose}{Provides console output informing about process (useful for large dataset).}

\item{symmetrization}{Function used to obtain a symmetric distance, so that DSPD(T1,T2) = DSPD(T2,T1) (e.g., \code{mean} or \code{min}).}

\item{all}{A flag to indicate that angles are desired for all triangles in the trajectory}

\item{selection}{A numeric or logical vector of the same length as \code{sites}, indicating a subset of site trajectories to be plotted.}

\item{traj.colors}{A vector of colors (one per site). If \code{selection != NULL} the length of the color vector should be equal to the number of sites selected.}

\item{axes}{The pair of principal coordinates to be plotted.}

\item{...}{Additional parameters for function \code{\link{arrows}}.}

\item{x}{A data.frame or matrix where rows are community states and columns are coordinates in an arbitrary space}

\item{target}{An integer vector of the community states to be projected.}

\item{trajectory}{An integer vector of the trajectory onto which target states are to be projected.}

\item{tol}{Numerical tolerance value to determine that projection of a point lies within the trajectory.}

\item{symmetric}{A logical flag to indicate a symmetric convergence comparison of trajectories.}
}
\value{
Function \code{trajectoryDistances} returns an object of class \code{\link{dist}} containing the distances between trajectories. Function \code{trajectorySegments} returns a list with the following elements:
\itemize{
  \item{\code{Dseg}: Distance matrix between segments.}
  \item{\code{Dini}: Distance matrix between initial points of segments.}
  \item{\code{Dfin}: Distance matrix between final points of segments.}
  \item{\code{Dinifin}: Distance matrix between initial points of one segment and the final point of the other.}
  \item{\code{Dfinini}: Distance matrix between final points of one segment and the initial point of the other.}
}

Function \code{trajectoryLengths} returns a data frame with the length of each segment on each trajectory and the total length of all trajectories. Function \code{trajectoryPCoA} returns the result of calling \code{\link{cmdscale}}.

Function \code{trajectoryAngles} returns a data frame with the angle between each pair of segments on each trajectory and the mean and standard deviation of those angles across each trajectory. 

Function \code{trajectoryPCoA} returns the result of calling \code{\link{cmdscale}}.

Function \code{trajectoryProjection} returns a data frame with the following columns:
\itemize{
  \item{\code{distanceToTrajectory}: Distances to the trajectory, i.e. rejection (\code{NA} for target points whose projection is outside the trajectory).}
  \item{\code{segment}: Segment that includes the projected point (\code{NA} for target points whose projection is outside the trajectory).}
  \item{\code{relativePosition}: Relative position of the projected point within the trajectory, i.e. values from 0 to 1 with 0 representing the start of the trajectory and 1 representing the end (\code{NA} for target points whose projection is outside the trajectory).}
}

Function \code{trajectoryConvergence} returns a list with two elements:
\itemize{
  \item{\code{tau}: A matrix with the statistic (Mann-Kendall's tau) of the convergence/divergence test between trajectories. If \code{symmetric=TRUE} then the matrix is square. Otherwise the statistic of the test of the row trajectory approaching the column trajectory.}
  \item{\code{p.value}: A matrix with the p-value of the convergence/divergence test between trajectories. If \code{symmetric=TRUE} then the matrix is square. Otherwise the p-value indicates the test of the row trajectory approaching the column trajectory.}
}

Function \code{trajectoryDirectionality} returns a vector with directionality values (one per trajectory).
Function \code{centerTrajectory} returns an object of class \code{\link{dist}}.
}
\description{
Set of functions for trajectory analysis
\itemize{
\item{Given a distance matrix between community states, functions \code{segmentDistances} and \code{trajectoryDistances} calculate the distance between pairs of directed segments and community trajectories, respectively.}
\item{Function \code{trajectoryLengths} calculates lengths of directed segments and complete trajectories.}
\item{Function \code{trajectoryAngles} calculates the angle between consecutive pairs of directed segments.}
\item{Function \code{trajectoryPCoA} performs principal coordinates analysis (\code{\link{cmdscale}}) and draws trajectories in the ordination scatterplot.}
\item{Function \code{trajectoryPlot} Draws trajectories in a scatterplot corresponding to the input coordinates.}
\item{Function \code{trajectoryProjection} projects a set of target points onto a specified trajectory and returns the distance to the trajectory (i.e. rejection) and the relative position of the projection point within the trajectory.}
\item{Function \code{trajectoryConvergence} performs the Mann-Kendall trend test on the distances between trajectories (symmetric test) or the distance between points of one trajectory to the other.}
\item{Function \code{trajectoryDirectionality} returns (for each trajectory) a statistic that measures directionality of the whole trajectory.}
\item{Function \code{centerTrajectories} shifts all trajectories to the center of the compositional space and returns a modified distance matrix.}
}
These functions consider community dynamics as trajectories in a chosen space of community resemblance and takes trajectories as objects to be compared. 
By adapting concepts and procedures used for the analysis of trajectories in space (i.e. movement data) (Besse et al. 2016), the functions allow assessing the resemblance between trajectories. 
Details of calculations are given in De \enc{Cáceres}{Caceres} et al (submitted)
}
\examples{
  #Description of sites and surveys
  sites = c(1,1,1,2,2,2)
  surveys=c(1,2,3,1,2,3)
  
  #Raw data table
  xy<-matrix(0, nrow=6, ncol=2)
  xy[2,2]<-1
  xy[3,2]<-2
  xy[4:6,1] <- 0.5
  xy[4:6,2] <- xy[1:3,2]
  xy[6,1]<-1
  
  #Distance matrix
  d = dist(xy)
  d
  
  trajectoryLengths(d, sites, surveys)
  trajectoryAngles(d, sites, surveys)
  segmentDistances(d, sites, surveys)$Dseg
  trajectoryDistances(d, sites, surveys, distance.type = "Hausdorff")
  trajectoryDistances(d, sites, surveys, distance.type = "DSPD")
  
  #Draw trajectories
  trajectoryPCoA(d, sites, traj.colors = c("black","red"), lwd = 2)
  
  
  #Should give the same results if surveys are not in order 
  #(here we switch surveys for site 2)
  temp = xy[5,]
  xy[5,] = xy[6,]
  xy[6,] = temp
  surveys[5] = 3
  surveys[6] = 2
  trajectoryLengths(dist(xy), sites, surveys)
  segmentDistances(dist(xy), sites, surveys)$Dseg
  trajectoryDistances(dist(xy), sites, surveys, distance.type = "Hausdorff")
  trajectoryDistances(dist(xy), sites, surveys, distance.type = "DSPD")
 
}
\references{
Besse, P., Guillouet, B., Loubes, J.-M. & François, R. (2016). Review and perspective for distance based trajectory clustering. IEEE Trans. Intell. Transp. Syst., 17, 3306–3317.

De \enc{Cáceres}{Caceres} M, Coll L, Legendre P, Allen RB, Wiser SK, Fortin MJ, Condit R & Hubbell S. (submitted). Trajectory analysis in community ecology.
}
\seealso{
\code{\link{cmdscale}}
}
\author{
Miquel De \enc{Cáceres}{Caceres}, Forest Sciences Center of Catalonia
}
