% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vegaspec.R
\name{vw_as_json}
\alias{vw_as_json}
\title{Coerce vegaspec to JSON}
\usage{
vw_as_json(spec, pretty = TRUE)
}
\arguments{
\item{spec}{An object to be coerced to \code{vegaspec}, a Vega/Vega-Lite specification}

\item{pretty}{\code{logical} indicates to use pretty (vs. minified) formatting}
}
\value{
\code{jsonlite::json} object
}
\description{
For Vega and Vega-Lite, the translation between lists and JSON is a little
bit particular. This function, \code{\link[=vw_as_json]{vw_as_json()}}, can be used to translate
to JSON; \code{\link[=as_vegaspec]{as_vegaspec()}} can be used to translate from JSON.
}
\examples{
  vw_as_json(spec_mtcars)

}
\seealso{
\code{\link[=as_vegaspec]{as_vegaspec()}}
}
