#' Simulated true data
#'
#' @description A data set of 200 simulated 'true' data, from which the observations are deduced, with two observed variables and two groups, non-compositional
#'
#' @format A data frame with 200 rows and 3 columns
#' \describe{
#'   \item{Var1}{simulated variable}
#'   \item{Var2}{simulated variable}
#'   \item{Group}{Factor with levels 'Group 1' and 'Group 2'}
#' }
"datatrue"


#' Simulated true compositional data
#'
#' @description A data set of 200 simulated 'true' data, from which the observations are deduced, with three observed variables and two groups, compositional
#'
#' @format A data frame with 200 rows and 4 columns
#' \describe{
#'   \item{Var1}{simulated variable, compositional}
#'   \item{Var2}{simulated variable, compositional}
#'   \item{Var3}{simulated variable, compositional}
#'   \item{Group}{Factor with levels 'Group 1' and 'Group 2'}
#' }
"datatrue_coda"

#' Simulated observation data
#'
#' @description A data set of 200 simulated observations with two observed variables and two groups, non-compositional
#'
#' @format A data frame with 200 rows and 3 columns
#' \describe{
#'   \item{Var1}{simulated observed variable}
#'   \item{Var2}{simulated observed variable}
#'   \item{Group}{Factor with levels 'Group 1' and 'Group 2'}
#' }
"dataobs"

#' Simulated observation of compositional data
#'
#' @description A data set of 200 simulated observations with three observed variables and two groups, compositional
#'
#' @format A data frame with 200 rows and 4 columns
#' \describe{
#'   \item{Var1}{simulated observed variable, compositional}
#'   \item{Var2}{simulated observed variable, compositional}
#'   \item{Var3}{simulated observed variable, compositional}
#'   \item{Group}{Factor with levels 'Group 1' and 'Group 2'}
#' }
"dataobs_coda"


#' Simulated observation uncertainties
#'
#' @description A data set of 200 simulated uncertainties with two variables and two groups, non-compositional
#'
#' @format A data frame with 200 rows and 3 columns
#' \describe{
#'   \item{Var1}{simulated observed variable}
#'   \item{Var2}{simulated observed variable}
#'   \item{Group}{Factor with levels 'Group 1' and 'Group 2'}
#' }
"uncertainties"

#' Simulated observation uncertainties of compositional data
#'
#' @description A data set of 200 simulated uncertainties with three variables and two groups, compositional
#'
#' @format A data frame with 200 rows and 4 columns
#' \describe{
#'   \item{Var1}{simulated observed variable, compositional}
#'   \item{Var2}{simulated observed variable, compositional}
#'   \item{Var3}{simulated observed variable, compositional}
#'   \item{Group}{Factor with levels 'Group 1' and 'Group 2'}
#' }
"uncertainties_coda"
