% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{vec_data}
\alias{vec_data}
\title{Extract underlying data}
\usage{
vec_data(x)
}
\arguments{
\item{x}{A vector or object implementing \code{vec_proxy()}.}
}
\value{
The data underlying \code{x}, free from any attributes except the names.
}
\description{
\Sexpr[results=rd, stage=render]{vctrs:::lifecycle("experimental")}

Extract the data underlying an S3 vector object, i.e. the underlying
(named) atomic vector, data frame, or list.
}
\section{Difference with \code{vec_proxy()}}{

\itemize{
\item \code{vec_data()} returns unstructured data. The only attributes
preserved are names, dims, and dimnames.

Currently, due to the underlying memory architecture of R, this
creates a full copy of the data for atomic vectors.
\item \code{vec_proxy()} may return structured data. This generic is the
main customisation point for accessing memory values in vctrs,
along with \code{\link[=vec_restore]{vec_restore()}}.

Methods must return a vector type. Records and data frames will
be processed rowwise.
}
}

\keyword{internal}
