% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields.R
\name{fields}
\alias{fields}
\alias{n_fields}
\alias{field}
\alias{field<-}
\title{Tools for accessing the fields of a record.}
\usage{
fields(x)

n_fields(x)

field(x, i)

field(x, i) <- value
}
\arguments{
\item{x}{A \link{rcrd}, i.e. a list of equal length vectors with unique names.}
}
\description{
A \link{rcrd} behaves like a vector, so \code{length()}, \code{names()}, and \code{$} can
not provide access to the fields of the underlying list. These helpers do:
\code{fields()} is equivalent to \code{names()}; \code{n_fields()} is equivalent to
\code{length()}; \code{field()} is equivalent to \code{$}.
}
\examples{
x <- new_rcrd(list(x = 1:3, y = 3:1, z = letters[1:3]))
n_fields(x)
fields(x)

field(x, "y")
field(x, "y") <- runif(3)
field(x, "y")
}
\keyword{internal}
