% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcpen.R
\name{vcpen}
\alias{vcpen}
\alias{summary.vcpen}
\title{Penalized Variance Components}
\usage{
vcpen(
  y,
  X,
  Kerns,
  frac1 = 0.8,
  lambda_factor = NULL,
  lambda_grid = NULL,
  maxiter = 1000,
  vc_init = NULL,
  print_iter = FALSE
)

\method{summary}{vcpen}(object, ..., digits = 4)
}
\arguments{
\item{y}{Numeric vector of traits. Only continuous trait currently allowed.}

\item{X}{Matrix of covariates (columns) for subjects (rows), matching subjects in the trait (y) vector.}

\item{Kerns}{List of kernel matrices: a kernel matrix for each  variance compenent. The last kernel matrix in the list (an identity matrix) is for the residual variance component.}

\item{frac1}{Fraction of penalty imposed on L1 penalty, between 0 and 1 (0 for only L2; 1 for only L1 penalty).}

\item{lambda_factor}{Weight for each vc (values between 0 and 1) for how much it should be penalized: 0 means no penalty. Default value of NULL implies weight of 1 for all vc's.}

\item{lambda_grid}{Vector of lambda penalties for fitting the penalized model. Best to order values from largest to smallest so parameter estimates from a large penalty can be used as initial values for the next smaller penalty. Default value of NULL implies initial values  of seq(from=.10, to=0, by=-0.01).}

\item{maxiter}{Maximum number of iterations allowed during penalized fitting.}

\item{vc_init}{Numeric vector of initial values for variance components. Default value of NULL implies initial values determined by 2 iterations of minque estimation.}

\item{print_iter}{Logical:  if TRUE, print the iteration results (mainly for refined checks)}

\item{object}{Fitted vcpen object (used in summary method)}

\item{\dots}{Optional arguments for summary method}

\item{digits}{Signficant digits for summary method}
}
\value{
object with S3 class vcpen
}
\description{
Penalized Variance Component analysis
}
\examples{
data(vcexample)
nvc <- 1+length(unique(doseinfo[,2]))
id <- 1:nrow(dose)
## vcs for genetic kernel matrices
Kerns <- vector("list", length=nvc)
for(i in 1:(nvc-1)){
  Kerns[[i]] <- kernel_linear(dose[,grep(i, doseinfo[,2])])
  rownames(Kerns[[i]]) <- id
  colnames(Kerns[[i]]) <- id
}
## vc for residual variance
Kerns[[nvc]] <- diag(nrow(dose))
rownames(Kerns[[nvc]]) <- id
colnames(Kerns[[nvc]]) <- id
fit  <- vcpen(response, covmat, Kerns, frac1 = .6)
summary(fit)

}
\author{
JP Sinnwell, DJ Schaid
}
