% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.gen}
\alias{meta.lc.gen}
\title{Confidence interval for a linear contrast of effect sizes}
\usage{
meta.lc.gen(alpha, est, se, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{est}{vector of parameter estimates}

\item{se}{vector of standard errors}

\item{v}{vector of contrast coefficients}
}
\value{
Returns 1-row matrix with the estimate for the contrast. The matrix
has the following columns:
\itemize{
\item Estimate - estimate of linear contrast
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
linear contrast of any type of effect size from two or more studies.
}
\examples{
est <- c(.55, .59, .44, .48, .26, .19)
se <- c(.054, .098, .029, .084, .104, .065)
v <- c(.5, .5, -.25, -.25, -.25, -.25)
meta.lc.gen(.05, est, se, v)

# Should return: 
#          Estimate         SE        LL        UL
# Contrast   0.2275 0.06755461 0.0950954 0.3599046

}
