% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.pbcor}
\alias{meta.ave.pbcor}
\title{Confidence interval for an average point-biserial correlation}
\usage{
meta.ave.pbcor(alpha, m1, m2, sd1, sd2, n1, n2, type, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of sample means for group 1}

\item{m2}{vector of sample means for group 2}

\item{sd1}{vector of sample SDs for group 1}

\item{sd2}{vector of sample SDs for group 2}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{type}{\itemize{
\item set to 1 for weighted variance
\item set to 2 for unweighted variance
}}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate
across all studies.  If bystudy is true, there is 1 additional row for
each study.  The matrix has the following columns:
\itemize{
\item Estimate - the estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average point-biserial correlation from two or more studies. Two types
of point-biserial correlations can be meta-analyzed. One type uses
an unweighted variance and is appropriate in 2-group experimental
designs. The other type uses a weighted variance and is appropriate in
2-group nonexperimental designs with simple random sampling within each
group. This function requires all point-biserial correlations to be of
the same type.  Use the meta.ave.gen function to meta-analyze any
combination of biserial correlation types.
}
\examples{
m1 <- c(21.9, 23.1, 19.8)
m2 <- c(16.1, 17.4, 15.0)
sd1 <- c(3.82, 3.95, 3.67)
sd2 <- c(3.21, 3.30, 3.02)
n1 <- c(40, 30, 24)
n2 <- c(40, 28, 25)
meta.ave.pbcor(.05, m1, m2, sd1, sd2, n1, n2, 2, bystudy = TRUE)

# Should return:
#          Estimate         SE        LL        UL
# Average 0.6159094 0.04363432 0.5230976 0.6942842
# Study 1 0.6349786 0.06316796 0.4842098 0.7370220
# Study 2 0.6160553 0.07776700 0.4255342 0.7380898
# Study 3 0.5966942 0.08424778 0.3903883 0.7283966


}
\references{
\insertRef{Bonett2020b}{vcmeta}
}
