% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_jitter}
\alias{v_jitter}
\title{Create Jittered Points Scatter Chart}
\usage{
v_jitter(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  width = NULL,
  height = NULL,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{width, height}{Amount of vertical and horizontal jitter. The jitter
is added in both positive and negative directions, so the total spread
is twice the value specified here.

If omitted, defaults to 40\% of the resolution of the data: this means the
jitter values will occupy 80\% of the implied bins. Categorical data
is aligned on the integers, so a width or height of 0.5 will spread the
data so it's not possible to see the distinction between the categories.}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create Jittered Points Scatter Chart
}
\examples{

library(vchartr)

data("mpg", package = "ggplot2")
data("penguins", package = "palmerpenguins")

# With continuous x
vchart(mpg) \%>\% 
  v_jitter(aes(cyl, hwy))

# with discrete x
vchart(penguins) \%>\%  
  v_jitter(aes(species, bill_length_mm))

# Colour points
vchart(mpg) \%>\% 
  v_jitter(aes(cyl, hwy, colour = class))

# Use smaller width/height to emphasise categories
vchart(mpg) \%>\% 
  v_jitter(aes(cyl, hwy), width = 0.25)

# Use larger width/height to completely smooth away discreteness
vchart(mpg) \%>\% 
  v_jitter(aes(cty, hwy), width = 0.5, height = 0.5)
}
