% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.R
\name{mark-line}
\alias{mark-line}
\alias{v_mark_vline}
\alias{v_mark_hline}
\alias{v_mark_segment}
\title{Add an horizontal or vertical line to a chart}
\usage{
v_mark_vline(
  vc,
  x,
  ...,
  .line.style.stroke = "#000",
  .line.style.lineDash = list(8, 8),
  .label.text = NULL,
  .label.position = "end",
  .label.refY = 0,
  .label.refX = 0,
  .endSymbol.style.visible = FALSE,
  .startSymbol.style.visible = FALSE
)

v_mark_hline(
  vc,
  y,
  ...,
  .line.style.stroke = "#000",
  .line.style.lineDash = list(8, 8),
  .label.text = NULL,
  .label.position = "insideEndBottom",
  .label.refY = -10,
  .label.refX = 0,
  .endSymbol.style.visible = FALSE,
  .startSymbol.style.visible = FALSE
)

v_mark_segment(
  vc,
  x,
  xend,
  y,
  yend,
  ...,
  .line.style.stroke = "#000",
  .line.style.lineDash = list(8, 8),
  .label.text = NULL,
  .label.position = "insideEndBottom",
  .label.refY = -10,
  .label.refX = 0,
  .endSymbol.style.visible = FALSE,
  .startSymbol.style.visible = FALSE
)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}}.}

\item{x, y, xend, yend}{Target position for the line.}

\item{...}{Additional parameters for the line,
see \href{https://www.visactor.io/vchart/option/commonChart#markLine}{online documentation} for more.}

\item{.line.style.stroke}{Stroke color.}

\item{.line.style.lineDash}{Used to configure the dashed line mode when filling lines.
It uses an array of values to specify the alternating lengths of lines and gaps that describe the pattern.}

\item{.label.text}{Text for the label on the line.}

\item{.label.position}{The label position of the dimension line (the relative position of the label relative to the line).
See \href{https://www.visactor.io/vchart/option/commonChart#markLine.label.position}{online documentation} for options.}

\item{.label.refY, .label.refX}{The offset in the vertical direction of the reference line.}

\item{.endSymbol.style.visible, .startSymbol.style.visible}{Whether the symbol element is visible or not.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Add an horizontal or vertical line to a chart
}
\examples{

library(vchartr)

# Vertical line
vchart(meteo_paris) \%>\%
  v_line(aes(month, temperature_avg)) \%>\%
  v_mark_vline(x = "May")

# Vertical lines with labels
vchart(meteo_paris) \%>\%
  v_line(aes(month, temperature_avg)) \%>\%
  v_mark_vline(
    x = c("May", "September"),
    .label.text = c("May", "September")
  )

# Horizontal line
vchart(meteo_paris) \%>\%
  v_line(aes(month, temperature_avg)) \%>\%
  v_mark_hline(y = 12)

# Both horizontal and vertical lines
vchart(meteo_paris) \%>\%
  v_line(aes(month, temperature_avg)) \%>\%
  v_mark_vline(x = "May") \%>\%
  v_mark_hline(y = 12)

# lines on a scatter plot
vchart(cars) \%>\%
  v_scatter(aes(speed, dist)) \%>\%
  v_mark_vline(x = mean(cars$speed)) \%>\%
  v_mark_hline(y = mean(cars$dist))

# segment
vchart(cars) \%>\%
  v_scatter(aes(speed, dist)) \%>\%
  v_mark_segment(x = 8, xend = 22, y = 12, yend = 100)

# line on date scale
vchart(temperatures) \%>\%
  v_line(aes(date, average)) \%>\%
  v_mark_vline(x = as.Date("2024-06-20"))

# segment on date scale
vchart(temperatures) \%>\%
  v_line(aes(date, average)) \%>\%
  v_mark_segment(
    x = as.Date("2024-04-01"), xend = as.Date("2024-07-01"),
    y = 12, yend = 24,
    .line.style.lineDash = 0,
    .line.style.stroke = "firebrick"
  )

}
