% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{chromR-class}
\alias{chromR-class}
\title{chromR class}
\description{
A class for representing chromosomes (or supercontigs, contigs, scaffolds, etc.).
}
\details{
Defines a class for chromosomal or contig data.
This

This object has a number of slots.

\itemize{
  \item \strong{name} name of the object (character)
  \item \strong{len} length of the sequence (integer)
  \item \strong{window_size} window size for windowing analyses (integer)

  \item \strong{seq} object of class ape::DNAbin
  \item \strong{vcf} object of class vcfR
  \item \strong{ann} annotation data in a gff-like data.frame

  \item \strong{var.info} a data.frame containing information on variants
  \item \strong{win.info} a data.frame containing information on windows
  \item \strong{seq.info} a list containing information on the sequence

}


The \strong{seq} slot contains an object of class ape::DNAbin.
A DNAbin object is typically either a matrix or list of DNAbin objects.
The matrix form appears to be better behaved than the list form.
Because of this behavior this slot should be the matrix form.
When this slot is not populated it is of class "NULL" instead of "DNAbin".
Note that characters need to be lower case when inserted into an object of class DNAbin.
The function \code{\link[base]{tolower}} can facilitate this.


The \strong{vcf} slot is an object of class vcfR \code{\link{vcfR-class}}.

The \strong{ann} slot is a data.frame containing \href{https://github.com/The-Sequence-Ontology/Specifications/blob/master/gff3.md}{gff format} data.
When this slot is not populated it has nrows equal to zero.

The \strong{var.info} slot contains a data.frame containing information about variants.
Every row of this data.frame is a variant.
Columns will typically contain the chromosome name, the position of the variant (POS), the mask as well as any other per variant information.

The \strong{win.info} slot contains a data.frame containing information about windows.
For example, window, start, end, length, A, C, G, T, N, other, variants and genic fields are stored here.

The \strong{seq.info} slot is a list containing two matrices.
The first matrix describes rectangles for called nucleotides and the second describes rectangles for 'N' calls.
Within each matrix, the first column indicates the start position and the second column indicates the end position of each rectangle.
}
\seealso{
\code{\link{vcfR-class}}, \code{\link[ape]{DNAbin}},
\href{https://github.com/samtools/hts-specs}{VCF specification}
\href{https://github.com/The-Sequence-Ontology/Specifications/blob/master/gff3.md}{gff3 format}
}
