% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_het.R
\name{is.het}
\alias{is.het}
\title{Query genotypes for heterozygotes}
\usage{
is.het(x, na_is_false = TRUE)
}
\arguments{
\item{x}{a matrix of genotypes}

\item{na_is_false}{should missing data be returned as NA (FALSE) or FALSE (TRUE)}
}
\description{
Query a matrix of genotypes for heterozygotes
}
\details{
This function was designed to identify heterozygous positions in a matrix of genotypes.
The matrix of genotypes can be created with \code{\link{extract.gt}}.
Because the goal was to identify heterozygotes it may be reasonable to ignore missing values by setting na_is_false to TRUE so that the resulting matrix will consist of only TRUE and FALSE.
In order to preserve missing data as missing na_is_false can be set to FALSE where if at least one allele is missing NA is returned.
}
\examples{
data(vcfR_test)
gt <- extract.gt(vcfR_test)
hets <- is.het(gt)


}
\seealso{
\code{\link{extract.gt}}
}

