% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVC_mle.R
\name{SVC_mle_control}
\alias{SVC_mle_control}
\alias{SVC_mle_control.default}
\alias{SVC_mle_control.SVC_mle}
\title{Set Parameters for \code{SVC_mle}}
\usage{
SVC_mle_control(...)

\method{SVC_mle_control}{default}(cov.name = c("exp", "sph"),
  tapering = NULL, cl = NULL, init = NULL, lower = NULL,
  upper = NULL, save.fitted = TRUE, profileLik = FALSE,
  mean.est = c("GLS", "OLS"), pc.prior = NULL, ...)

\method{SVC_mle_control}{SVC_mle}(object, ...)
}
\arguments{
\item{...}{further parameters yet to be implemented}

\item{cov.name}{name of the covariance function defining the covariance matrix of the GRF. Currently, only \code{"exp"} for the exponential and \code{"exp"} for spherical covariance functions are supported.}

\item{tapering}{if \code{NULL}, no tapering is applied. If a scalar is given, covariance tapering with this taper range is applied, for all GRF modelling the SVC.}

\item{cl}{cluster for parallelization. Currently not supported.}

\item{init}{numeric. Initial values for optimization procedure. The vector consists of p-times (alternating) scale and variance, the nugget variance and the p + p.fix mean effects}

\item{lower}{lower bound for optim, default \code{NULL} sets the lower bounds to 1e-6 for covariance parameters and \code{-Inf} for mean parameters.}

\item{upper}{upper bound for optim, default \code{NULL} sets the upper bounds to \code{Inf} for covariance and mean parameters.}

\item{save.fitted}{logical. If \code{TRUE}, calculates the fitted values and residuals after MLE and saves them.}

\item{profileLik}{logical. If \code{TRUE}, MLE is done over profile Likelihood of covariance parameters.}

\item{mean.est}{if \code{profileLik} is \code{TRUE}, the means have to be estimated seperately. \code{"GLS"} uses the generalized least square estimate while \code{"OLS"} uses the ordinary least squares estiamte.}

\item{pc.prior}{takes vector of \eqn{\rho_0, \alpha_\rho, \sigma_0, \alpha_\sigma} to compute penalized complexity priors. This regulates the optimization process. Currently, only supported for Gaussian random fields of Matérn class. Based on the idea Simpson and Fulgstad.}

\item{object}{An object of class \code{SVC_mle}. The function then extracts the control settings from the particular function call used to compute \code{object}.}
}
\value{
A list with which \code{\link{SVC_mle}} can be controlled
}
\description{
Function to set up control parameters for \code{\link{SVC_mle}}
}
\examples{
control <- SVC_mle_control(init = rep(0.3, 10))
# or
control <- SVC_mle_control()
control$init <- rep(0.3, 10)

}
\seealso{
\code{\link{SVC_mle}}
}
\author{
Jakob Dambon
}
