% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.alignment.R
\name{run.alignment}
\alias{run.alignment}
\title{Run alignment}
\usage{
run.alignment(fastq.specification, output.directory, paired.end = FALSE,
  sample.directories = TRUE, output.subdirectory = FALSE,
  job.name.prefix = NULL, job.group = "alignment", quiet = FALSE,
  verify.options = !quiet)
}
\arguments{
\item{fastq.specification}{Data frame detailing FASTQ files to be processed, typically from prepare.fastq.specification}

\item{output.directory}{Path to project directory}

\item{paired.end}{Logical indicating whether paired-end sequencing was performed}

\item{sample.directories}{Logical indicating whether all sample files should be saved to sample-specific subdirectories (will be created)}

\item{output.subdirectory}{If further nesting is required, name of subdirectory. If no further nesting, set to FALSE}

\item{job.name.prefix}{Prefix for job names on the cluster}

\item{job.group}{Group job should be associated with on cluster}

\item{quiet}{Logical indicating whether to print commands to screen rather than submit them}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}
}
\value{
None
}
\description{
Run alignment
}
\details{
Runs alignment (and related processing steps) on each sample.
}
\examples{
run.alignment(
  fastq.specification = data.frame(
    sample.id = c('1', '2'),
    reads = c('1-R1.fastq.gz', '2-R1.fastq.gz'),
    mates = c('1-R2.fastq.gz', '2-R2.fastq.gz'),
    patient.id = c('P1', 'P1'),
    tissue = c('tumour', 'normal')
  ),
  output.directory = '.',
  quiet = TRUE,
  paired.end = TRUE
)

}
