% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{mean.field.value}
\alias{mean.field.value}
\title{mean.field.value}
\usage{
\method{mean}{field.value}(variants, field = c("TUMOUR.DP", "NORMAL.DP",
  "NORMAL.AF", "TUMOUR.AF", "QUAL"), caller = c("consensus", "vardict",
  "pgm", "mutect", "isis", "varscan", "lofreq"))
}
\arguments{
\item{variants}{Data frame with variants}

\item{field}{String giving field of interest.}

\item{caller}{String giving caller to calculate values from}
}
\value{
Vector of mean values.
}
\description{
Get mean value of a variant annotation field
}
\details{
As part of the variant merging process, annotated variant data frames are merged into 
	one, with the value from each caller prefixed by CALLER. For example, the VarDict normal allele 
	freqeuncy will have header VARDICT.NORMAL.AF. This function takes the average of all callers' value 
	for a given field, removing NA's. If only a single caller is present in the data frame, that value is returned.
}
