% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanProteinStructures.R
\name{RemoveOoR.o}
\alias{RemoveOoR.o}
\title{Remove Occupancy Out of Range Atoms}
\usage{
RemoveOoR.o(atoms.chains.oi)
}
\arguments{
\item{atoms.chains.oi}{The data.frame containing the PDB file information;
aka the PDB structure}
}
\value{
data.frame of the PDB structure \emph{without} the offending atoms
}
\description{
Removes atoms with occupancy values out of accepted range.
}
\details{
Accepted occupancy values range from 0 to 1 with values for
modeled atoms being 0.0 or 0.01 and highly conserved or represented atoms
throughout the lattice having values greater than 0.9 and commonly
possessing values of 1.0. This function identifies occupancy values
less than 0 and greater than 1 and removes them from the structure.
}
\examples{
  \donttest{
  nrow(PDB.4dfr$atom)
  PDB.4dfr.OoR.o <- RemoveOoR.o(PDB.4dfr$atom)
  nrow(PDB.4dfr.OoR.o)
  }

}
\seealso{
Other "Clean Protein Structure": \code{\link{CleanProteinStructures}},
  \code{\link{RemoveHydrogenAtoms}},
  \code{\link{RemoveModeledAtoms}},
  \code{\link{RemoveOoR.b}},
  \code{\link{RetainWatersWithinX}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Clean Protein Structure"}
