% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\docType{class}
\name{constant_parameters}
\alias{constant_parameters}
\title{Constant parameter class}
\format{\code{\link{R6Class}} object.}
\usage{
constant_parameters
}
\value{
Object of \code{\link{R6Class}}
}
\description{
Class providing a constant parameter object with methods to calculate
the integral of the parameter and  the squared parameter over a time span.
}
\section{Methods}{

\describe{
  \item{\code{integral}}{Calculates the integral given the initial
   and final times. The arguments are two \code{\link{timeDate}}
   object with the initial  and final times.
   It returns a \code{numeric} scalar with the integral}
  \item{\code{integral_square} (\code{public})}{Calculates the integral
   of the squared constant parameter given the initial and final times.
   The arguments are two \code{\link{timeDate}} object with the initial
   and final times. It returns a \code{numeric} scalar with the integral}
  \item{\code{get} (\code{public})}{get the constant}
}
}
\examples{
r <- constant_parameters$new(0.01)
#Over the full year (365 days) the integral should evaluate to 0.01
r$integral(timeDate::timeDate("2016-07-09"), timeDate::timeDate("2017-07-09"))
#Over the full year the integral square should evaluate to 0.001
r$integral_square(timeDate::timeDate("2016-07-09"), timeDate::timeDate("2017-07-09"))
}
\keyword{datasets}

