% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMGrank.R
\name{EMGrank}
\alias{EMGrank}
\title{EMGrank}
\usage{
EMGrank(Pi, Rho, mini, maxi, X, Y, eps, rank, fast)
}
\arguments{
\item{Pi}{An initialization for pi}

\item{Rho}{An initialization for rho, the variance parameter}

\item{mini}{integer, minimum number of iterations in the EM algorithm, by default = 10}

\item{maxi}{integer, maximum number of iterations in the EM algorithm, by default = 100}

\item{X}{matrix of covariates (of size n*p)}

\item{Y}{matrix of responses (of size n*m)}

\item{eps}{real, threshold to say the EM algorithm converges, by default = 1e-4}

\item{rank}{vector of possible ranks}

\item{fast}{boolean to enable or not the C function call}
}
\value{
A list (corresponding to the model collection) defined by (phi,LLF):
  phi : regression mean for each cluster, an array of size p*m*k
  LLF : log likelihood with respect to the training set
}
\description{
Run an generalized EM algorithm developped for mixture of Gaussian regression
models with variable selection by an extension of the low rank estimator.
Reparametrization is done to ensure invariance by homothetic transformation.
It returns a collection of models, varying the number of clusters and the rank of the regression mean.
}
