% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_projection.r
\name{bed_projection}
\alias{bed_projection}
\title{Projection test for query interval overlap.}
\usage{
bed_projection(x, y, genome, by_chrom = FALSE)
}
\arguments{
\item{x}{\link{ivl_df}}

\item{y}{\link{ivl_df}}

\item{genome}{\link{genome_df}}

\item{by_chrom}{compute test per chromosome}
}
\value{
\link{ivl_df} with the following columns:
\itemize{
\item \code{chrom} the name of chromosome tested if \code{by_chrom = TRUE},
otherwise has a value of \code{whole_genome}
\item \code{p.value} p-value from a binomial test. p-values > 0.5
are converted to \code{1 - p-value} and \code{lower_tail} is \code{FALSE}
\item \code{obs_exp_ratio} ratio of observed to expected overlap frequency
\item \code{lower_tail} \code{TRUE} indicates the observed overlaps are in the lower tail
of the distribution (e.g., less overlap than expected). \code{FALSE} indicates
that the observed overlaps are in the upper tail of the distribution (e.g.,
more overlap than expected)
}
}
\description{
Projection test for query interval overlap.
}
\details{
Interval statistics can be used in combination with
\code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:do]{dplyr::do()}} to calculate
statistics for subsets of data. See \code{vignette('interval-stats')} for
examples.
}
\examples{
genome <- read_genome(valr_example("hg19.chrom.sizes.gz"))

x <- bed_random(genome, seed = 1010486)
y <- bed_random(genome, seed = 9203911)

bed_projection(x, y, genome)

bed_projection(x, y, genome, by_chrom = TRUE)

}
\seealso{
\url{https://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1002529}

Other interval statistics: 
\code{\link{bed_absdist}()},
\code{\link{bed_fisher}()},
\code{\link{bed_jaccard}()},
\code{\link{bed_reldist}()}
}
\concept{interval statistics}
