% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacing.r
\name{interval_spacing}
\alias{interval_spacing}
\title{Calculate interval spacing.}
\usage{
interval_spacing(x)
}
\arguments{
\item{x}{tbl of intervals}
}
\value{
\code{data_frame} with \code{.spacing} column.
}
\description{
Overlapping intervals are merged. Spacing for the first interval of each
chromosome is undefined (\code{NA}).
}
\examples{
x <- tibble::tribble(
~chrom, ~start, ~end,
'chr1', 1,      100,
'chr1', 150,    200,
'chr2', 200,    300
)

interval_spacing(x)
  
}

