% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_random.r
\name{bed_random}
\alias{bed_random}
\title{Generate randomly placed intervals on a genome.}
\usage{
bed_random(genome, length = 1000, n = 1e+06, seed = 0)
}
\arguments{
\item{genome}{genome tbl}

\item{length}{length of intervals}

\item{n}{number of intervals to generate}

\item{seed}{seed RNG for reproducible intervals}
}
\description{
Generate randomly placed intervals on a genome.
}
\examples{
genome <- tibble::tribble(
  ~chrom,  ~size,
  "chr1",  10000000,
  "chr2",  50000000,
  "chr3",  60000000,
  "chrX",  5000000
) 

# random intervals (unsorted)
bed_random(genome, seed = 10104)

# 500 random intervals of length 500 
bed_random(genome, length = 500, n = 500, seed = 10104)

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/random.html}

Other single-set-ops: \code{\link{bed_cluster}},
  \code{\link{bed_complement}}, \code{\link{bed_flank}},
  \code{\link{bed_merge}}, \code{\link{bed_shift}},
  \code{\link{bed_shuffle}}, \code{\link{bed_slop}}
}

