% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible.R
\name{make_feasible}
\alias{make_feasible}
\title{Make an infeasible system feasible.}
\usage{
make_feasible(x, ...)
}
\arguments{
\item{x}{\code{\link{validator}} object with the validation rules.}

\item{...}{passed to \code{\link{detect_infeasible_rules}}}
}
\value{
\code{\link{validator}} object with feasible rules.
}
\description{
Make an infeasible system feasible, by removing the minimum (weighted) number of rules, such that the remaining
rules are not conflicting.
This function uses \code{\link{detect_infeasible_rules}} for determining the rules to be removed.
}
\examples{
rules <- validator( x > 0)

is_infeasible(rules)

rules <- validator( rule1 = x > 0
                  , rule2 = x < 0
                  )

is_infeasible(rules)

detect_infeasible_rules(rules)
make_feasible(rules)

# find out the conflict with this rule
is_contradicted_by(rules, "rule1")
}
\seealso{
Other feasibility: \code{\link{detect_boundary_cat}},
  \code{\link{detect_boundary_num}},
  \code{\link{detect_infeasible_rules}},
  \code{\link{is_contradicted_by}},
  \code{\link{is_infeasible}}
}
\concept{feasibility}
