% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate.tbl_validation}
\alias{aggregate.tbl_validation}
\title{Count the number of invalid rules or records.}
\usage{
\method{aggregate}{tbl_validation}(x, by = c("rule", "record", "id"), ...)
}
\arguments{
\item{x}{\code{\link[=tbl_validation]{tbl_validation()}} object}

\item{by}{either by "rule" or by "record"}

\item{...}{not used}
}
\value{
A \code{\link[dbplyr:tbl.src_dbi]{dbplyr::tbl_dbi()}} object that represents the aggregation query
(to be executed) on the database.
}
\description{
See the number of valid and invalid checks either by rule or by record.
}
\details{
The result of a \code{\link[=confront]{confront()}} on a db  \code{tbl} results in a lazy squery. That
is it builds a query without executing it. To store the result in the database
use \code{\link[=compute]{compute()}} or \code{\link[=values]{values()}}.
}
\examples{
income <- data.frame(id = 1:2, age=c(12,35), salary = c(1000,NA))
con <- dbplyr::src_memdb()
tbl_income <- dplyr::copy_to(con, income, overwrite=TRUE)
print(tbl_income)

# Let's define a rule set and confront the table with it:
rules <- validator( is_adult   = age >= 18
                    , has_income = salary > 0
)

# and confront!
# in general with a db table it is handy to use a key
cf <- confront(tbl_income, rules, key="id")
aggregate(cf, by = "rule")
aggregate(cf, by = "record")

# to tweak performance of the db query the following options are available
# 1) store validation result in db
cf <- confront(tbl_income, rules, key="id", compute = TRUE)
# or identical
cf <- confront(tbl_income, rules, key="id")
cf <- compute(cf)

# 2) Store the validation sparsely
cf_sparse <- confront(tbl_income, rules, key="id", sparse=TRUE )

show_query(cf_sparse)
values(cf_sparse, type="tbl")
}
