% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confrontation.R
\name{check_that}
\alias{check_that}
\title{Simple data validation interface}
\usage{
check_that(dat, ...)
}
\arguments{
\item{dat}{an R object carrying data}

\item{...}{a comma-separated set of validating expressions.}
}
\value{
An object of class \code{\link{validation}}
}
\description{
Simple data validation interface
}
\section{Details}{

Creates an object of class \code{\link{validator}} and \code{\link{confront}}s it with the data.
This function is easy to use in combination with the \pkg{magrittr} pipe operator.
}

\examples{

cf <- check_that(women, height>0, height/weight < 0.5)
cf
summary(cf)
barplot(cf)


\dontrun{
# this works only after loading the 'magrittr' package
women \%>\% 
  check_that(height>0, height/weight < 0.5) \%>\%
  summary()
}

}
