% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ann.R
\name{observed}
\alias{observed}
\title{Return observed target values.}
\usage{
observed(object)
}
\arguments{
\item{object}{an object of class `ann' as returned by \code{\link{ann}} or
of class `nnet' as returned by \code{\link[nnet]{nnet}}.}
}
\value{
a 1-column matrix of observed target values.
}
\description{
Return observed target values used for fitting `ann' or `nnet' ANN models.
}
\details{
This function can be invoked by calling \code{observed(x)} for an
object \code{x} of class `ann' or `nnet'.
}
\examples{
# Get observed values of y used to train ann object `fit'.
# ---
data("ar9")
samp <- sample(1:1000, 200)
y <- ar9[samp, ncol(ar9)]
x <- ar9[samp, -ncol(ar9)]
x <- x[, c(1,4,9)]
fit <- ann(x, y, size = 1, act_hid = "tanh", act_out = "linear", rang = 0.1)
y_obs <- observed(fit)
}

