% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vachette_data.R
\name{vachette_data}
\alias{vachette_data}
\title{Initialize vachette object with required data}
\usage{
vachette_data(
  obs.data,
  typ.data,
  sim.data = NULL,
  covariates,
  ref.dosenr,
  log.x = FALSE,
  iiv.correction = FALSE,
  error.model = c("proportional", "additive"),
  model.name = NULL,
  mappings = NULL
)
}
\arguments{
\item{obs.data}{data.frame; Observed data}

\item{typ.data}{data.frame; Typical (population) curves}

\item{sim.data}{data.frame; Simulated (VPC) data}

\item{covariates}{named character vector; Covariate names with reference values in vachette transformation}

\item{ref.dosenr}{integer; Dose number to use as the reference dose, corresponding to value in "dosenr" column in input data}

\item{log.x}{logical; Apply log(x) conversion. Default \code{FALSE}}

\item{iiv.correction}{logical; Apply inter-individual variability correction. Default \code{FALSE}}

\item{error.model}{character; Applied error model, \code{"proportional"} or \code{"additive"}. Default \code{"proportional"}}

\item{model.name}{character; Optional model name for plot output}

\item{mappings}{named character vector;  Optional mappings to be included if column names in input \code{data.frame} differ from required column names.
See Required Columns section:}
}
\value{
\code{vachette_data}
}
\description{
Initialize vachette object with required data
}
\details{
If "dosenr" column is missing it will be automatically calculated using the priority of available columns:
   \itemize{
     \item "EVID": If available in data, "dosenr" will be calculated using \code{cumsum(EVID==1)}
     \item "ADDL"/"II": If "ADDL" and "II" are available in data, "dosenr" will be calculated given additional dose number and interval
     \item "AMT": If only "AMT" column exists in data, "dosenr" will be calculated using \code{cumsum(AMT!=0)}
   }
}
\section{Required columns \code{obs.data}}{

\itemize{
 \item \code{"ID"} - Subject ID
 \item \code{"x"} - Typically time
 \item \code{"PRED"} - Population prediction, required if \code{iiv.correction = TRUE}
 \item \code{"IPRED"} - Individual prediction, required if \code{iiv.correction = TRUE}
 \item \code{"OBS"} - DV
 \item \code{"dosenr"} - Dose number; unique dose number for ID/time point
}
}

\section{Required columns \code{typ.data}}{

\itemize{
 \item \code{"ID"} - Subject ID
 \item \code{"x"} - Typically time
 \item \code{"PRED"} - Population prediction
 \item \code{"dosenr"} - Dose number; unique dose number for ID/time point
}
}

\section{Required columns \code{sim.data}}{

\itemize{
 \item \code{"ID"} - Subject ID
 \item \code{"x"} - Typically time
 \item \code{"PRED"} - Population prediction, required if \code{iiv.correction = TRUE}
 \item \code{"IPRED"} - Individual prediction, required if \code{iiv.correction = TRUE}
 \item \code{"REP"} - Replicate number
}
}

\examples{
obs <- read.csv(system.file(package = "vachette", "examples", "iv-obs.csv"))
typ <- read.csv(system.file(package = "vachette", "examples", "iv-typ-minmax.csv"))

vd <- vachette_data(
  obs.data = obs,
  typ.data = typ,
  covariates = c(WT = 70),
  mappings = c(OBS = "DV", x = "time"),
  model.name  = "IV"
  )


}
