% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_samples.R
\name{posterior_samples}
\alias{posterior_samples}
\title{Extract Posterior Samples}
\usage{
posterior_samples(object)
}
\arguments{
\item{object}{An object of class \code{vicc}}
}
\value{
An object of class  \code{data.frame}
}
\description{
Extract posterior samples for \code{vicc} objects
}
\examples{
\donttest{
# congruent trials
congruent <- subset(flanker, cond == 0)

# subset 25 from each group
dat <- congruent[unlist(tapply(1:nrow(congruent),
                            congruent$id,
                            head, 25)), ]

# fit model
fit <- vicc(y  = dat$rt,
            group = dat$id,
            iter = 250,
            burnin = 10,
            type =  "customary")

samps <- posterior_samples(fit)
}
}
