% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_clr.R
\name{clr}
\alias{clr}
\title{Calibrated Label Ranking (CLR) for multi-label Classification}
\usage{
clr(
  mdata,
  base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  ...,
  cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{...}{Others arguments passed to the base algorithm for all subproblems}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{RPCmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{rpcmodel}{A RPC model.}
   \item{brmodel}{A BR model used to calibrated the labels.}
  }
}
\description{
Create a CLR model for multilabel classification.
}
\details{
CLR is an extension of label ranking that incorporates the calibrated
scenario. The introduction of an artificial calibration label,
separates the relevant from the irrelevant labels.
}
\examples{
model <- clr(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
}
}
\references{
Brinker, K., Furnkranz, J., & Hullermeier, E. (2006). A unified model for
   multilabel classification and ranking. In Proceeding of the ECAI 2006:
   17th European Conference on Artificial Intelligence. p. 489-493.
 Furnkranz, J., Hullermeier, E., Loza Mencia, E., & Brinker, K. (2008).
   Multilabel classification via calibrated label ranking.
   Machine Learning, 73(2), 133-153.
}
\seealso{
Other Transformation methods: 
\code{\link{brplus}()},
\code{\link{br}()},
\code{\link{cc}()},
\code{\link{ctrl}()},
\code{\link{dbr}()},
\code{\link{ebr}()},
\code{\link{ecc}()},
\code{\link{eps}()},
\code{\link{esl}()},
\code{\link{homer}()},
\code{\link{lift}()},
\code{\link{lp}()},
\code{\link{mbr}()},
\code{\link{ns}()},
\code{\link{ppt}()},
\code{\link{prudent}()},
\code{\link{ps}()},
\code{\link{rakel}()},
\code{\link{rdbr}()},
\code{\link{rpc}()}

Other Pairwise methods: 
\code{\link{rpc}()}
}
\concept{Pairwise methods}
\concept{Transformation methods}
