% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_cc.R
\name{cc}
\alias{cc}
\title{Classifier Chains for multi-label Classification}
\usage{
cc(
  mdata,
  base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  chain = NA,
  ...,
  cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{chain}{A vector with the label names to define the chain order. If
empty the chain is the default label sequence of the dataset. (Default:
\code{NA})}

\item{...}{Others arguments passed to the base algorithm for all subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{CCmodel} containing the set of fitted
  models, including: \describe{
  \item{chain}{A vector with the chain order.}
  \item{labels}{A vector with the label names in expected order.}
  \item{models}{A list of models named by the label names.}
}
}
\description{
Create a Classifier Chains model for multilabel classification.
}
\details{
Classifier Chains is a Binary Relevance transformation method based to
predict multi-label data. This is based on the one-versus-all approach to
build a specific model for each label. It is different from BR method due the
strategy of extended the attribute space with the 0/1 label relevances of all
previous classifiers, forming a classifier chain.
}
\examples{
model <- cc(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Use a specific chain with J48 classifier
mychain <- sample(rownames(toyml$labels))
model <- cc(toyml, 'J48', mychain)

# Set a specific parameter
model <- cc(toyml, 'KNN', k=5)

#Run with multiple-cores
model <- cc(toyml, 'RF', cores = 5, seed = 123)
}
}
\references{
Read, J., Pfahringer, B., Holmes, G., & Frank, E. (2011). Classifier chains
   for multi-label classification. Machine Learning, 85(3), 333-359.

 Read, J., Pfahringer, B., Holmes, G., & Frank, E. (2009). Classifier Chains
   for Multi-label Classification. Machine Learning and Knowledge Discovery
   in Databases, Lecture Notes in Computer Science, 5782, 254-269.
}
\seealso{
Other Transformation methods: 
\code{\link{brplus}()},
\code{\link{br}()},
\code{\link{clr}()},
\code{\link{ctrl}()},
\code{\link{dbr}()},
\code{\link{ebr}()},
\code{\link{ecc}()},
\code{\link{eps}()},
\code{\link{esl}()},
\code{\link{homer}()},
\code{\link{lift}()},
\code{\link{lp}()},
\code{\link{mbr}()},
\code{\link{ns}()},
\code{\link{ppt}()},
\code{\link{prudent}()},
\code{\link{ps}()},
\code{\link{rakel}()},
\code{\link{rdbr}()},
\code{\link{rpc}()}
}
\concept{Transformation methods}
