% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_lift.R
\name{lift}
\alias{lift}
\title{LIFT for multi-label Classification}
\usage{
lift(mdata, base.method = getOption("utiml.base.method", "SVM"),
  ratio = 0.1, ..., cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.method}{A string with the name of the base method. (Default:
\code{options("utiml.base.method", "SVM")})}

\item{ratio}{Controll the number of clusters being retained. Must be between
0 and 1. (Default: \code{0.1})}

\item{...}{Others arguments passed to the base method for all subproblems}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{LIFTmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{models}{A list of the generated models, named by the label names.}
  }
}
\description{
Create a multi-label learning with Label specIfic FeaTures (LIFT) model.
}
\details{
LIFT firstly constructs features specific to each label by conducting
clustering analysis on its positive and negative instances, and then performs
training and testing by querying the clustering results.
}
\examples{
model <- lift(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Runing lift with a specific ratio
model <- lift(toyml, "RF", 0.15)
}
}
\references{
Zhang, M.-L., & Wu, L. (2015). Lift: Multi-Label Learning with
 Label-Specific Features. IEEE Transactions on Pattern Analysis and Machine
 Intelligence, 37(1), 107-120.
}
\seealso{
Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{ctrl}}, \code{\link{dbr}}, \code{\link{ebr}},
  \code{\link{ecc}}, \code{\link{eps}},
  \code{\link{homer}}, \code{\link{lp}}, \code{\link{mbr}},
  \code{\link{ns}}, \code{\link{ppt}},
  \code{\link{prudent}}, \code{\link{ps}},
  \code{\link{rakel}}, \code{\link{rdbr}},
  \code{\link{rpc}}
}

