% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_table.R
\name{build_table.lm}
\alias{build_table.lm}
\title{Build summary tables from lm model objects}
\usage{
\method{build_table}{lm}(
  .object,
  ...,
  .test = c("F", "Chisq"),
  .show.test = FALSE,
  .level = 0.95,
  .percent.sign = TRUE,
  .digits = 1,
  .p.digits = 4
)
}
\arguments{
\item{.object}{An object of class \code{\link[stats]{lm}}.}

\item{...}{One or more unquoted expressions separated by commas representing
columns in the data.frame. May be specified using
\code{\link[tidyselect:select_helpers]{tidyselect helpers}}. If left empty,
all terms are summarized.}

\item{.test}{A character. The name of the
\code{\link[stats:add1]{stats::drop1}} test to use with the model.}

\item{.show.test}{A logical. Append a columns for the test and accompanying
statistic used to derive the p-value.}

\item{.level}{A double. The confidence level required.}

\item{.percent.sign}{A logical. Paste a percent symbol after all reported
frequencies.}

\item{.digits}{An integer. The number of digits to round numbers to.}

\item{.p.digits}{An integer. The number of p-value digits to report. Note
that the p-value still rounded to the number of digits specified in
\code{.digits}.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} summarizing the
provided object.
}
\description{
Takes a linear regression model object and summarizes it into a
ready to export, human-readable summary table.
}
\examples{
library(dplyr)

data_mtcars <- datasets::mtcars \%>\%
  mutate_at(vars('vs', 'am'), as.logical) \%>\%
  mutate_at(vars('gear', 'carb', 'cyl'), as.factor)

fit <- lm(mpg ~ vs + drat + cyl, data = data_mtcars)

fit \%>\% build_table()
}
\seealso{
\code{\link{build_table}}
}
