% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-map.R
\name{plot_usmap}
\alias{plot_usmap}
\title{Conveniently plot basic US map}
\usage{
plot_usmap(
  regions = c("states", "state", "counties", "county"),
  include = c(),
  exclude = c(),
  data = data.frame(),
  values = "values",
  theme = theme_map(),
  labels = FALSE,
  label_color = "black",
  ...
)
}
\arguments{
\item{regions}{The region breakdown for the map, can be one of
(\code{"states"}, \code{"state"}, \code{"counties"}, \code{"county"}).
The default is \code{"states"}.}

\item{include}{The regions to include in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or FIPS code.
For counties, the FIPS must be provided as there can be multiple counties with the
same name. If states are provided in the county map, only counties in the included states
will be returned.}

\item{exclude}{The regions to exclude in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or FIPS code.
For counties, the FIPS must be provided as there can be multiple counties with the
same name. The regions listed in the \code{include} parameter are applied first and the
\code{exclude} regions are then removed from the resulting map. Any excluded regions
not present in the included regions will be ignored.}

\item{data}{A data frame containing values to plot on the map. This
parameter should be a data frame consisting of two columns,
a fips code (2 characters for state, 5 characters for county)
and the value that should be associated with that region. The
columns of \code{data} \emph{must} be \code{fips} or \code{state} and
the value of the `values` parameter.}

\item{values}{The name of the column that contains the values to be associated
with a given region. The default is \code{"value"}.}

\item{theme}{The theme that should be used for plotting the map. The default
is \code{theme_map} from \href{https://github.com/jrnold/ggthemes}{ggthemes}.}

\item{labels}{Whether or not to display labels on the map. Labels are not displayed
by default. For now, labels only work for state maps.
County labels may be added in the future.}

\item{label_color}{The color of the labels to display. Corresponds to the \code{color}
option in the \code{\link[ggplot2]{aes}} mapping. The default is \code{"black"}.
\href{http://www.stat.columbia.edu/~tzheng/files/Rcolor.pdf}{Click here}
for more color options.}

\item{...}{Other arguments to pass to \code{ggplot2::aes()}. These are
often aesthetics, used to set an aesthetic to a fixed value, like \code{color = "red"}
or \code{size = 3}. They affect the appearance of the polygons used to render
the map (for example fill color, line color, line thickness, etc.). If any of
\code{color}/\code{colour}, \code{fill}, or \code{size} are not specified they
are set to their default values of \code{color="black"}, \code{fill="white"},
and \code{size=0.4}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that contains a basic
  US map with the described parameters. Since the result is a \code{ggplot}
  object, it can be extended with more \code{geom} layers, scales, labels,
  themes, etc.
}
\description{
Conveniently plot basic US map
}
\examples{
plot_usmap()
plot_usmap(regions = "states")
plot_usmap(regions = "counties")
plot_usmap(regions = "state")
plot_usmap(regions = "county")

# Output is ggplot object so it can be extended
# with any number of ggplot layers
library(ggplot2)
plot_usmap(include = c("CA", "NV", "ID", "OR", "WA")) +
  labs(title = "Western States")

# Color maps with data
plot_usmap(data = statepop, values = "pop_2015")

# Include labels on map (e.g. state abbreviations)
plot_usmap(data = statepop, values = "pop_2015", labels = TRUE)
# Choose color for labels
plot_usmap(data = statepop, values = "pop_2015", labels = TRUE, label_color = "white")

}
\seealso{
\code{\link{usmap}}, \code{\link[ggplot2]{theme}}
}
