# Copyright (c) 2013 Stefan Moeding
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.


##############################################################################
#' Extract parts of a "\code{USL}" object
#'
#' The operator extracts a part of a \code{\link{USL-class}} object.
#'
#' This is a generic method for the class used in the usl package.
#'
#' The operator is used internally by functions like \code{\link{coef}}, so
#' it is necessary to have a working implementation of the \code{coef}
#' function.
#'
#' @usage \S4method{$}{USL}(x, name)
#' @param x Object from which to extract elements.
#' @param name A literal character string or a \link{name} (possibly quoted).
#'
#' @seealso \code{\link{USL-class}}, \code{\link{Extract}}
#'
#' @examples
#' \dontrun{
#' ## get coefficients from a usl model
#' usl.model$coefficients
#' }
#'
#' @aliases $,USL-method
#' @docType methods
#' @rdname extract-methods
#' @keywords internal
#'
setMethod(
  f = "$",
  signature = "USL",
  definition = function(x, name) { slot(x, name) }
)
