% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_fns.R
\name{get_error}
\alias{get_error}
\title{Evaluate error metric between data and model prediction}
\usage{
get_error(params, param_names, free_param_index, data, model_list,
  inv_param_transform_fn)
}
\arguments{
\item{params}{named vector of the parameters from which the model prediction should be generated.}

\item{param_names}{names of parameter vector.}

\item{free_param_index}{logical TRUE/FALSE vector indicating whether the parameters A, delta, B, gamma are to be recovered. This should be c(TRUE, TRUE, TRUE, TRUE) for the biphasic model and c(FALSE, FALSE, TRUE, TRUE) for the single phase model.}

\item{data}{dataframe with columns for the subject's viral load measurements ('vl'), and timing of sampling ('time')}

\item{model_list}{character indicating which model is begin fit. Can be either 'four' for the biphasic model, or 'two' for the single phase model.}

\item{inv_param_transform_fn}{list of transformation functions to be used when back-transforming the transformed parameters. Should be the inverse of the forward transformation functions. Defaults to exponential.}
}
\description{
For a given parameter set, this function computes the predicted viral load curve and evaluates the error metric between the prediction and observed data (to be passed to optim).
}
