% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{ui}
\alias{ui}
\alias{ui_line}
\alias{ui_todo}
\alias{ui_done}
\alias{ui_oops}
\alias{ui_info}
\alias{ui_code_block}
\alias{ui_stop}
\alias{ui_warn}
\alias{ui_silence}
\alias{ui_field}
\alias{ui_value}
\alias{ui_path}
\alias{ui_code}
\title{User interface}
\usage{
ui_line(x = character(), .envir = parent.frame())

ui_todo(x, .envir = parent.frame())

ui_done(x, .envir = parent.frame())

ui_oops(x, .envir = parent.frame())

ui_info(x, .envir = parent.frame())

ui_code_block(x, copy = rlang::is_interactive(), .envir = parent.frame())

ui_stop(x, .envir = parent.frame())

ui_warn(x, .envir = parent.frame())

ui_silence(code)

ui_field(x)

ui_value(x)

ui_path(x, base = NULL)

ui_code(x)
}
\arguments{
\item{x}{A character vector.

For block styles, conditions, and questions, each element of the
vector becomes a line, and the result is processed by \code{\link[glue:glue]{glue::glue()}}.
For inline styles, each element of the vector becomes an entry in a
comma separated list.}

\item{.envir}{Used to ensure that \code{\link[glue:glue]{glue::glue()}} gets the correct
environment. For expert use only.}

\item{copy}{If \code{TRUE}, the session is interactive, and the clipr package
is installed, will copy the code block to the clipboard.}

\item{code}{Code to execute with usually UI output silenced.}

\item{base}{If specified, paths will be displayed relative to this path.}
}
\value{
The block styles, conditions, and questions are called for their
side-effect. The inline styles return a string.
}
\description{
These functions are used to construct the user interface of usethis. Use
them in your own package so that your \code{use_} functions work the same way
as usethis.

The \code{ui_} functions can be broken down into four main categories:
\itemize{
\item block styles: \code{ui_line()}, \code{ui_done()}, \code{ui_todo()}, \code{ui_oops()},
\code{ui_info()}.
\item conditions: \code{ui_stop()}, \code{ui_warn()}.
\item questions: \code{\link[=ui_yeah]{ui_yeah()}}, \code{\link[=ui_nope]{ui_nope()}}.
\item inline styles: \code{ui_field()}, \code{ui_value()}, \code{ui_path()}, \code{ui_code()}.
}

The question functions \code{\link[=ui_yeah]{ui_yeah()}} and \code{\link[=ui_nope]{ui_nope()}} have their own \link[=ui-questions]{help page}.
}
\section{Silencing output}{

All UI output (apart from \code{ui_yeah()}/\code{ui_nope()} prompts) can be silenced
by setting \code{options(usethis.quiet = TRUE)}. Use \code{ui_silence()} to selected
actions.
}

\examples{
new_val <- "oxnard"
ui_done("{ui_field('name')} set to {ui_value(new_val)}")
ui_todo("Redocument with {ui_code('devtools::document()')}")

ui_code_block(c(
  "Line 1",
  "Line 2",
  "Line 3"
))
}
\seealso{
Other user interface functions: 
\code{\link{ui-questions}}
}
\concept{user interface functions}
\keyword{internal}
