% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{prune_and_reorder_vector}
\alias{prune_and_reorder_vector}
\title{Prune and reorder vector elements}
\usage{
prune_and_reorder_vector(vec, filter.vec)
}
\arguments{
\item{vec}{a vector with \code{names} attribute}

\item{filter.vec}{a character vector whose values will be used to filter the
\code{vec} elements}
}
\value{
the pruned and re-arranged vector.
}
\description{
Given two vectors, the first one's elements are pruned and reordered according
to the common values of the second vector and the elements' \emph{\code{names}
(attribute) of the first}. If there no common such values, an empty vector is
returned.
}
\examples{
vec = c(1,2,3)
names(vec) = c("a","b","c")

filter.vec1 = c("a")
prune_and_reorder_vector(vec, filter.vec1)

filter.vec2 = c("c", "ert", "b")
prune_and_reorder_vector(vec, filter.vec2)

}
